﻿function order_submit(form) {
    var suUrl = "http://" + window.order_http_host + "/api/v1/order/add.json";

    //alert("Submitting Form" + form.getAttribute("id"));

    // NOTE: THIS does not work when submit handler is not attached directly to DOM node by code (e.g. $(#orderForm).submit(function(){...});)
    //alert("Submitting Form This=" + this.getAttribute("id"));

    var $form = $(form);
    var dataArray = $form.serializeArray();

    $.ajax({
        method: 'POST',     // used to be type:
        url: suUrl,
        data: dataArray,
        dataType: "json",
        crossDomain: true,
        success: order_onSuccess,
        error: order_onError
    });


    order_flag_sending();

    //alert("Preventing default form submission");
    return false;
}

function order_onSuccess(d) {
    console.log(d);

    if (d && (d.AdditionalInfo.Result == "Success")) {
        order_set_message(true, "success", 'Confirmation.Order.Add.Success', d.Data.Identifier);
        order_flag_sent();

    } else if (d.AdditionalInfo.Messages) {
        order_set_messages(true, "error", d.AdditionalInfo.Messages);
        order_flag_ready();

    } else {
        order_set_message(true, "error", 'Error.Order.NoResponse');
        order_flag_ready();
    }
}

function order_onError(xhr, ts, et) {
    //alert("ServerError: " + et);
    order_set_message(true, "error", $.i18n('Error.Order.NoResponse'));
    order_flag_ready();
}

function order_flag_sending() {
    var $submitButton = $('#btSubmit');
    $submitButton.html($.i18n('Order.Button.Submit.Label.Clicked'));
    $submitButton.attr("disabled", "disabled");

    $('#orderHelp').hide();

    order_set_form_enabled(false);
    order_set_message(false, "note", null);
}

function order_flag_sent() {
    //order_set_form_enabled(false);
    $('#orderDetails').hide();

    var $submitButton = $('#btSubmit');
    $submitButton.html($.i18n('Order.Button.Submit.Label'));
    $submitButton.attr("disabled", "disabled");
    $submitButton.hide();

    $('#orderDoneControls').show();
    $('#orderSuccessHelp').show();
    $('#navFooter').hide();
}

function order_flag_ready() {
    order_set_form_enabled(true);
    var $submitButton = $('#btSubmit');
    $submitButton.html($.i18n('Order.Button.Submit.Label'));
    $submitButton.removeAttr("disabled");
}

function order_set_form_enabled(isEnabled) {
    var $formFields = $("#orderForm :input");
    if (!$formFields) {
        return;
    }

    if (isEnabled) {
        $formFields.removeAttr("disabled");
    } else {
        $formFields.prop("disabled", "disabled");
    }

}

function order_set_message(isVisible, messageClass, messageId, messageArgs, messageText) {
    // STEP 1: Convert single arguments into an array of one arg
        if (messageArgs && messageArgs.constructor !== Array) {
            messageArgs = [messageArgs];
        }

    // STEP 2: Build messages array of one message object
        var messages = [{
            Id: messageId,
            Args: messageArgs,
            Text: messageText
        }];

    // STEP 3: Call on main set_messages function to do the work
    return order_set_messages(isVisible, messageClass, messages);
}

function order_set_messages(isVisible, messageClass, messages) {
    var $messageContainer = $("#orderMessage");
    if (!$messageContainer) {
        alert(messageText);
        return;
    }

    var classes = ["error", "success", "note"];
    classes.forEach(function (item) {
        if (item == messageClass) {
            $messageContainer.addClass(item);
        } else {
            $messageContainer.removeClass(item);
        }
    });

    var messageText = "";
    if (messages.constructor === Array) {
        for (var i = 0; i < messages.length; i++) {
            var messageElementType = (messages.length > 1) ? "li" : "span";
            var message = messages[i];

            // Message Wrapper START
            messageText += "<" + messageElementType + " class=\"i18n i18n-args\" data-i18n-id=\"" + message.Id + "\" data-context=\"" + message.Context + "\"";
            if (message.Args) {
                messageText += " data-i18n-args=\"" + message.Args.join('|') + "\"";
            }
            messageText += ">";

            // Default Text (may be empty)
            var messageElementText = message.Text;

            // Message Translated Text            
            if (message.Id) {
                // Build parms array
                var args = [message.Id];        // Param 1: Message Id
                if (message.Args) {
                    // Params 2,3,4... Arguments to message (to match placeholders in translation)
                    args.push.apply(args, message.Args);        // Append every item from Message.Args array to existing array args
                }

                // Look up message Id in translations
                messageElementText = $.i18n.apply(null, args);
            }

            // Test whether translated text succeeded
            if (messageElementText === message.Id) {
                // i18n failed to find the message in the language file. Use default text representation
                messageElementText = message.Text;
            }

            messageText += messageElementText;
            
            // Message Wrapper END
            messageText += "</" + messageElementType + ">";
        }
    }

    $messageContainer.html(messageText);
    $messageContainer.toggle(isVisible);

    if (isVisible) {
        window.location.hash = 'page';
    }
}