﻿function locale_onLanguageChange(element) {
    var locale = element.value;
    if (locale.length != 2) {
        return;
    }
    if (locale === $.i18n.locale) {
        return;
    }

    locale_set(element.value, true);
}



function locale_set_default() {
    //    Process for setting default locale, loading all translations and then applying
    //    $.i18n({ locale: 'en' });
    //    $.i18n().load({
    //        'en': 'asset/i18n/en.json',
    //        'es': 'asset/i18n/es.json'
    //    });
    //    $('body').i18n();

    // STEP 1: Determine language that should be used
        var locale = 'en';  // default
        if (sessionStorage.pm_locale) {
            locale = sessionStorage.pm_locale;
            //alert('Got Locale from Session Storage: ' + locale);
        }

    // STEP 2: See if URL is requesting a different locale
        var params = get_location_params();
        if (params["lang"]) {
            locale = params["lang"];
            //alert('Got Locale from URL: ' + locale);
        }

    // STEP 3: Apply locale
        locale_set(locale);
}


function locale_set(locale) {
    var args = Object();
    args[locale] = 'asset/i18n/' + locale + '.json';

    // Store locale selection for later
    sessionStorage.pm_locale = locale;

    $.i18n().locale = locale;
    $.i18n().load(args).done(locale_apply);    
}

function locale_apply() {
    //alert('Applying Locale ...');

    // STEP 1: Apply translations. This will result in text appearing 
    //         on the page with placeholders for arguments in certain 
    //         cases
        $('body').i18n();

    // STEP 2: Apply arguments to translated text
        $('.i18n-args').each(function () {
            var $this = $(this);
            var messageId = $this.attr('data-i18n-id');

            if (!messageId) {
                return;
            }

            var params = [messageId];

            var args = $this.attr('data-i18n-args');
            if (args) {
                params.push.apply(params, args.split('|'));
            }

            var text = $.i18n.apply(null, params);
            $this.html(text);
        });

    // STEP 3: Display currently selected language in UI controls
        locale_apply_updateUi();
}

function locale_apply_updateUi() {
    $('.pm-lang-select').each(function () {
        var $control = $(this);

        $control.val(sessionStorage.pm_locale);
        $control.css(
            'background-image',
            "url('asset/img/i18n/" + sessionStorage.pm_locale + ".png')"
        );
    });
}


function get_uri_params(queryString) {
    // From: https://stackoverflow.com/a/28554494/949129

    var params = {};
    queryString.split('&').forEach(function (pair) {
        pair = pair.split('=');
        if (pair[1] !== undefined) {
            var key = decodeURIComponent(pair[0]);
            var val = decodeURIComponent(pair[1]);
            val = val ? val.replace(/\++/g, ' ').trim() : '';

            if (key.length === 0) {
                return;
            }
            if (params[key] === undefined) {
                params[key] = val;
            }
            else {
                if ("function" !== typeof params[key].push) {
                    params[key] = [params[key]];
                }
                params[key].push(val);
            }
        }
    });

    return params;
}


// Returns JS object contining querystring parameters
function get_location_params(forceRefresh) {
    if (window.pm_params && !forceRefresh) {
        return window.pm_params;
    }

    window.pm_params = get_uri_params(window.location.search.substring(1));

    return window.pm_params;
}


function nav_set_return_location() {
    sessionStorage.pm_return_location = window.location.href;
    return true;
}

function nav_return() {
    if (sessionStorage.pm_return_location) {
        window.location = sessionStorage.pm_return_location;
        return false;
    }

    //window.history.back(); 
    window.location = "index.htm";
    return false;
}

// For use with select2 combobox. (Not currently used)
//function locale_format_option(option) {
//    if (!option.element.value || option.element.value.length != 2) {
//        return option.text;
//    }
//    var baseUrl = "asset/img/i18n/";
//    var $option = $('<span><img src="' + baseUrl + '/' + option.element.value.toLowerCase() + '.png" class="img-flag" /> ' + option.text + '</span>');
//    return $option;
//};


// Actions to run on every page load
//$(document).ready(function () {
////    $('.pm-lang-select').select2({
////        minimumResultsForSearch: Infinity,
////        templateResult: locale_format_option,
////        width: '25em'
////    });
//});